/**
 *
 * @package		PageFlex
 * @author		PageFlex Team (phucpm.it@gmail.com)
 * @copyright           PageFlex Team
 * @link		http://page-flex.com
 * @since		Version 1.0
 * @filesource
 *
 */
$(function() {
    var table = $('.table-body-container');
    var Comment = function() {
        var baseURL = "?admin-page=comment";
        var form = $('form');
        var alertMessage = $('#alertMessage');
        //Edit Comment
        var validatorComment = function() {
            var errors = new Array();
            var content = form.find("textarea[name=content]").val();
            var id = +form.find("text[name=id]").val();
            if (content.length < 2 || content.length > 500) {
                errors.push(base.getMessage('validatorContent'));
            }
            if (id < 0) {
                errors.push(base.getMessage('validatorID'));
            }
            return errors;
        };
        var initEdit = function(obj) {
            form[0].reset();
            form.find('textarea[name=content]').text($.trim(obj.content));
            form.find('input[name=id]').val($.trim(obj.id));
        };
        var resetEdit = function() {
            form[0].reset();
        };
        var saveEdit = function() {
            var id = +form.find('input[name=id]').val();
            var content = form.find('textarea[name=content]').val();
            var validator = validatorComment();
            if (validator.length === 0) {
                $.post(baseURL + '&act=ajax_save', {
                    id: id,
                    content: content
                }, function(result) {
                    if (result !== 0) {
                        var tr = table.find('tr[data-id="' + id + '"]').first();
                        tr.find('.commentContent').html(result);
                        base.notification('success', base.getMessage('saveEditSuccess'));
                    } else {
                        base.notification('error', base.getMessage('saveEditError'));
                    }
                    $('#editComment').modal('hide');
                });
            } else {
                base.alertMessageBootstrap('You see the following error', 'danger', validator, alertMessage);
            }
        };
        return {
            resetEdit: resetEdit,
            initEdit: initEdit,
            saveEdit: saveEdit
        };
    }();
    //Edit comment
    $('#listComments').find('button[name=btnEdit]').on('click', function(e) {
        e.preventDefault();
        var obj, row;
        row = table.find('tr[data-id='+$(this).data('id')+']');
        obj = {
            content: row.find('.commentContent').text(),
            id: $(this).data('id')
        };
        Comment.initEdit(obj);
        $("#editComment").modal('show');
    });
    $('#btnSaveEdit').on('click', function() {
        Comment.saveEdit();
    });
});